!define NAME "PortableOpenOffice"
!define APP "OpenOffice"
!define VER "1.1.1"
!define WEBSITE "johnhaller.com/jh/useful_stuff/portable_openoffice/"
!define DEFAULTEXE "soffice.exe"
!define DEFAULTAPPDIR "openoffice\program"

;=== Program Details
Name "${NAME}"
OutFile "${NAME}.exe"
Caption "${NAME} - Portable and Proud"
VIProductVersion "${VER}.0"
VIAddVersionKey FileDescription "${NAME} Launcher runs ${APP} from a removable drive"
VIAddVersionKey LegalCopyright "GPL"
VIAddVersionKey Comments "Allows ${APP} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "by John T. Haller et al"
VIAddVersionKey OriginalFilename "${NAME}.exe"
VIAddVersionKey FileVersion "${VER}"

;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True

;=== Program Icon
Icon "${APP}.ico"

Var PROGRAMDIRECTORY
Var USERPROFILEDIRECTORY
Var ADDITIONALPARAMETERS
Var EXECSTRING
Var WAITFORPROGRAM
Var PROGRAMEXECUTABLE
Var INIPATH

Section "Main"
	;=== Find the INI file, if there is one
		IfFileExists "$EXEDIR\${NAME}.ini" "" CheckSubINI
			StrCpy "$INIPATH" "$EXEDIR\"
			Goto ReadINI

	CheckSubINI:
		IfFileExists "$EXEDIR\${NAME}\${NAME}.ini" "" CheckSubSubINI
			StrCpy "$INIPATH" "$EXEDIR\${NAME}\"
			Goto ReadINI

	CheckSubSubINI:
		IfFileExists "$EXEDIR\PortableApps\${NAME}\${NAME}.ini" "" CheckPortableAppsINI
			StrCpy "$INIPATH" "$EXEDIR\PortableApps\${NAME}\"
			Goto ReadINI

	CheckPortableAppsINI:
		IfFileExists "$EXEDIR\Data\${NAME}\${NAME}.ini" ""  NoINI
			StrCpy "$INIPATH" "$EXEDIR\Data\${NAME}\"
			Goto ReadINI

	ReadINI:
		;=== Read the parameters from the INI file
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APP}Directory"
		StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\$0"

		;=== Check that the above required parameters are present
		IfErrors NoINI

		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "AdditionalParameters"
		StrCpy "$ADDITIONALPARAMETERS" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "WaitFor${APP}"
		StrCpy "$WAITFORPROGRAM" $0
		ReadINIStr $0 "$INIPATH\${NAME}.ini" "${NAME}" "${APP}Executable"
		StrCpy "$PROGRAMEXECUTABLE" $0

		;=== Any missing unrequired INI entries will be an empty string, ignore associated errors
		ClearErrors

		;=== Correct PROGRAMEXECUTABLE if blank
		StrCmp $PROGRAMEXECUTABLE "" "" EndINI
			StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"
			Goto EndINI

	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy "$ADDITIONALPARAMETERS" ""
		StrCpy "$WAITFORPROGRAM" "false"
		StrCpy "$PROGRAMEXECUTABLE" "${DEFAULTEXE}"

		IfFileExists "$EXEDIR\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableProgramDIR
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\${DEFAULTAPPDIR}"
			GoTo EndINI

		CheckPortableProgramDIR:
			IfFileExists "$EXEDIR\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableAppsDIR
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\${NAME}\${DEFAULTAPPDIR}"
			GoTo EndINI

		CheckPortableAppsDIR:
			IfFileExists "$EXEDIR\PortableApps\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" CheckPortableAppsSplitDIR
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\PortableApps\${NAME}\${DEFAULTAPPDIR}"
			GoTo EndINI

		CheckPortableAppsSplitDIR:
			IfFileExists "$EXEDIR\Apps\${NAME}\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy "$PROGRAMDIRECTORY" "$EXEDIR\Apps\${NAME}\${DEFAULTAPPDIR}"
			GoTo EndINI	

	EndINI:
		IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		MessageBox MB_OK|MB_ICONEXCLAMATION `$PROGRAMEXECUTABLE was not found.  Please check your configuration`
		Abort
		
	FoundProgramEXE:
		;=== Get any passed parameters
		Call GetParameters
		Pop $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE"`
		Goto AdditionalParameters

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" $0`

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" LaunchNow

		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`

	LaunchNow:
		StrCmp $WAITFORPROGRAM "true" LaunchAndWait LaunchAndClose

	LaunchAndWait:
		ExecWait $EXECSTRING
		GoTo TheEnd

	LaunchAndClose:
		Exec $EXECSTRING

	TheEnd:

SectionEnd

Function "GetParameters"
  Push $R0
  Push $R1
  Push $R2
  StrCpy $R0 $CMDLINE 1
  StrCpy $R1 '"'
  StrCpy $R2 1
  StrCmp $R0 '"' loop
    StrCpy $R1 ' ' ; we're scanning for a space instead of a quote
  loop:
    StrCpy $R0 $CMDLINE 1 $R2
    StrCmp $R0 $R1 loop2
    StrCmp $R0 "\" "" "nofile"
      IntOp $2 $R2 + 1
    nofile:
    ;MessageBox MB_OK "r0: $R0"
    StrCmp $R0 "" loop2
    IntOp $R2 $R2 + 1
    Goto loop
  loop2:
    IntOp $R0 $R2 - $2
    IntOp $R0 $R0 - 4
    ;MessageBox MB_OK "$R2 - $2 = $R0"
    StrCpy $R7 $CMDLINE $R0 $2 ; we save the filename
    ;MessageBox MB_OK "$2"
  loop2b:
    IntOp $R2 $R2 + 1
    StrCpy $R0 $CMDLINE 1 $R2
    ;MessageBox MB_OK "rr0: $R0"
    StrCmp $R0 " " loop2b
  StrCpy $R0 $CMDLINE "" $R2
  Pop $R2
  Pop $R1
  Exch $R0
FunctionEnd
